/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.roles;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import noppes.npcs.CustomNpcs;
import noppes.npcs.api.constants.JobType;
import noppes.npcs.api.entity.ICustomNpc;
import noppes.npcs.api.entity.data.role.IJobFollower;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.roles.JobInterface;

public class JobFollower
extends JobInterface
implements IJobFollower {
    public EntityNPCInterface following = null;
    public String name = "";

    public JobFollower(EntityNPCInterface npc) {
        super(npc);
        this.type = JobType.FOLLOWER;
    }

    @Override
    public boolean isWorking() {
        return this.isFollowing();
    }

    @Override
    public boolean aiShouldExecute() {
        if (this.npc.isAttacking()) {
            return false;
        }
        if (this.following != null) {
            if (this.following.isKilled()) {
                this.following = null;
                return false;
            }
            double dist = this.npc.func_70032_d((Entity)this.following);
            if (dist <= 1.5) {
                if (!this.npc.func_70661_as().func_75500_f()) {
                    this.npc.func_70661_as().func_75499_g();
                }
                return true;
            }
            if (dist > (double)this.getRange()) {
                boolean bo = this.npc.func_70661_as().func_75497_a((Entity)this.following, 1.0);
                if (!bo) {
                    this.following = null;
                }
            } else {
                this.following = null;
            }
            if (this.following != null) {
                return true;
            }
        }
        List list = new ArrayList();
        try {
            list = this.npc.field_70170_p.func_72872_a(EntityNPCInterface.class, this.npc.func_174813_aQ().func_72314_b((double)this.getRange(), (double)this.getRange(), (double)this.getRange()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (EntityNPCInterface entity : list) {
            if (entity == this.npc || entity.isKilled() || !entity.display.getName().equalsIgnoreCase(this.name)) continue;
            this.following = entity;
            break;
        }
        return false;
    }

    @Override
    public void aiUpdateTask() {
        this.npc.func_70671_ap().func_75650_a(this.following.field_70165_t, this.following.field_70163_u + (double)this.following.func_70047_e(), this.following.field_70161_v, 10.0f, (float)this.npc.func_70646_bf());
    }

    @Override
    public String getFollowing() {
        return this.name;
    }

    @Override
    public ICustomNpc<?> getFollowingNpc() {
        if (this.following == null) {
            return null;
        }
        return this.following.wrappedNPC;
    }

    private int getRange() {
        int dist = Math.min(this.npc.followRange(), this.npc.stats.aggroRange);
        if (dist > CustomNpcs.NpcNavRange) {
            return CustomNpcs.NpcNavRange;
        }
        return dist;
    }

    public boolean hasOwner() {
        return !this.name.isEmpty() && this.isFollowing();
    }

    @Override
    public boolean isFollowing() {
        return this.following != null;
    }

    @Override
    public void load(NBTTagCompound compound) {
        super.load(compound);
        this.type = JobType.FOLLOWER;
        this.name = compound.func_74779_i("FollowingEntityName");
    }

    @Override
    public void resetTask() {
        this.following = null;
    }

    @Override
    public void setFollowing(String n) {
        this.name = n;
    }

    @Override
    public NBTTagCompound save(NBTTagCompound compound) {
        super.save(compound);
        compound.func_74778_a("FollowingEntityName", this.name);
        return compound;
    }
}

